<?php

namespace App\Repositories\SMS;

use Illuminate\Support\Facades\Log;


class KavenegarRepository implements SMSRepositoryInterface
{
    public function send($body, $idPattern, $mobile, $token2 = 0, $token3 = 0)
    {
        try {
            $receptor = $mobile;
            $api = new \Kavenegar\KavenegarApi(env("KAVENEGAR_APIKEY"));
            $response = $api->VerifyLookup($receptor, $body, $token2, $token3, $idPattern);
            if ($response->status == 200) {
                return ['status' => 200, 'message' => 'ارسال موفق بود '];
            } else {
                return ['status' => 500, 'message' => 'ارسال موفق نبود '];
            }
        } catch (\Kavenegar\Exceptions\ApiException $e) {
            return ['status' => 500, 'message' => 'ارسال موفق نبود '];
        } catch (\Kavenegar\Exceptions\HttpException $e) {
            return ['status' => 500, 'message' => 'ارسال موفق نبود '];
        }
    }


    public function sendSMSSendCode($code, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_CODE');
        return $this->send($code, $idPattern, $mobile);
    }

    public function sendSMSToUserAwaitingRestaurantApproval($orderId, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TO_USER_AWAITING_RESTAURANT_APPROVAL');
        return $this->send($orderId, $idPattern, $mobile);
    }

    public function sendSMSOrderStatus($orderId, $textStatus, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TO_USER_ORDER_STATUS');
        return $this->send($orderId, $idPattern, $mobile, $textStatus);
    }

    public function sendSMSOrderDeliveredWithCashBack($name, $amount, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TO_USER_ORDER_DELIVERED_CASHBACK');

        return $this->send($name, $idPattern, $mobile, (string)$amount);
    }

    public function sendSMSToDriver($orderId, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TO_DRIVER_NEW_ORDER');
        return $this->send($orderId, $idPattern, $mobile);
    }

    public function sendSMSNewOrder($orderId, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TO_RESTAURANT_NEW_ORDER');
        return $this->send($orderId, $idPattern, $mobile);
    }

    public function sendSMSTicketAnswered($ticketId, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TICKETING_ANSWERED');
        return $this->send($ticketId, $idPattern, $mobile);
    }

    public function sendSMSWaitingAnswer($ticketId, $mobiles)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_TICKETING_WAITING_ANSWER');
        return $this->send($ticketId, $idPattern, $mobiles);
    }

    public function OpenOrderReminder($orderId, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_Open_Order_Reminder');
        return $this->send($orderId, $idPattern, $mobile);
    }
    public function sendSMSCashBack($mobile, $restaurantName, $priceCashBack, $date)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_CASH_BACK');
        return $this->send( $restaurantName, $idPattern, $mobile ,$priceCashBack, $date);
    }

    public function sendSMSOrderDelayApproval($orderId, $customerName, $orderAmount, $restaurantName, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_ORDER_DELAY_APPROVAL');
        return $this->send($orderId, $idPattern, $mobile, $customerName, $orderAmount, $restaurantName);
    }

    public function sendSMSOrderDelayDelivery($orderId, $customerName, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_ORDER_DELAY_DELIVERY');
        return $this->send($orderId, $idPattern, $mobile, $customerName);
    }

    public function sendSMSInactiveProducts($inactiveCount, $restaurantName, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_INACTIVE_PRODUCTS');
        return $this->send($inactiveCount, $idPattern, $mobile, $restaurantName);
    }

    public function sendSMSWelcomeCoupon($couponCode, $mobile)
    {
        $idPattern = env('KAVENEGAR_SEND_SMS_WELCOME_COUPON');
        return $this->send($couponCode, $idPattern, $mobile);
    }
}

