<?php

namespace App\Repositories\SMS;

use App\Models\Gateway;
use Illuminate\Support\Facades\Log;
use Melipayamak\MelipayamakApi;

class MelipayamakDedicatedNumberRepository implements SMSRepositoryInterface
{
    public function send($body, $idPattern, $mobile)
    {
        $from = env('MELIPAYAMAK_FROM');
        $username = env('MELIPAYAMAK_USERNAME');
        $password = env('MELIPAYAMAK_PASSWORD');
        try {
            $api = new MelipayamakApi($username, $password);
            $sms = $api->sms();
            $to = $mobile;
            $response = $sms->send($to, $from, $body);
            $json = json_decode($response);
            echo $json->Value;
        } catch (\Exception $e) {
            Log::info($e->getMessage());
            echo $e->getMessage();
        }
        return ['status' => 200, 'message' => 'ارسال موفق بود '];
    }


    public function sendSMSSendCode($code, $mobile)
    {
        $text = "دوست عزیز، کد تایید شما به مجموعه ملی فلو " . $code . " میباشد .";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSToUserAwaitingRestaurantApproval($orderId, $mobile)
    {
//        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_USER_AWAITING_RESTAURANT_APPROVAL');
//        return $this->send([$orderId], $idPattern, $mobile);
    }

    public function sendSMSOrderStatus($orderId, $textStatus, $mobile)
    {
//        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_USER_ORDER_STATUS');
//        return $this->send([$orderId, $textStatus], $idPattern, $mobile);
    }

    public function sendSMSOrderDeliveredWithCashBack($name, $amount, $mobile)
    {
        $text = "سلام " . $name . " جان! ممنونیم ازینکه ملی فلو را برای گذراندن اوقات خود انتخاب کردید، مبلغی از سفارشتان در کیف پول شما ذخیره شد و میتوانید در سفارش بعدی خود، از آن استفاده کنید ❤️ موجودی کیف پول شما : " . $amount . " ☎️ 09116050069 🌐 melifluo.ir";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSToDriver($orderId, $mobile)
    {
//        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_DRIVER_NEW_ORDER');
//        return $this->send([$orderId], $idPattern, $mobile);
    }

    public function sendSMSNewOrder($orderId, $mobile)
    {
        $text = "سلام دُکی،سفارش جدیدی با شماره " . $orderId . " ثبت شد. melifluo.ir";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSTicketAnswered($ticketId, $mobile)
    {
        $text = "تیکت شماره " . $ticketId . " پاسخ داده شده است. ☎️ 09116050069 🌐 melifluo.ir";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSWaitingAnswer($ticketId, $mobiles)
    {
        $text = "تیکت شماره " . $ticketId . " منتظر پاسخ دادن است. ☎️ 09116050069 🌐 melifluo.ir";
        return $this->send($text, null, $mobiles);
    }
    public function OpenOrderReminder($orderId, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_Open_Order_Reminder');
        return $this->send([$orderId], $idPattern, $mobile);
    }
    public function sendSMSCashBack($mobile, $restaurantName, $priceCashBack, $date)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_CASH_BACK');
        return $this->send(['restaurantName' => $restaurantName, 'priceCashBack' => $priceCashBack, 'date' => $date], $idPattern, $mobile);
    }

    public function sendSMSOrderDelayApproval($orderId, $customerName, $orderAmount, $restaurantName, $mobile)
    {
        $text = "سفارش #{$orderId} از {$customerName} به مبلغ {$orderAmount} منتظر تایید شماست.";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSOrderDelayDelivery($orderId, $customerName, $mobile)
    {
        $text = "سفارش #{$orderId} از {$customerName} منتظر تحویل است. لطفا اقدام فرمایید.";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSInactiveProducts($inactiveCount, $restaurantName, $mobile)
    {
        $text = "{$inactiveCount} عدد از محصولات فروشگاه {$restaurantName} شما غیرفعال میباشد لطفا سریعا نسبت به تعیین وضعیت و فعال سازی محصولات اقدام فرمایید.";
        return $this->send($text, null, $mobile);
    }

    public function sendSMSWelcomeCoupon($couponCode, $mobile)
    {
        $text = "به خانواده لیموفود خوش آمدید! کد تخفیف شما: {$couponCode} - این کد را می‌توانید یکبار در هر رستوران استفاده کنید.";
        return $this->send($text, null, $mobile);
    }
}
