<?php

namespace App\Repositories\SMS;

use App\Models\Gateway;
use Illuminate\Support\Facades\Log;
use Melipayamak\MelipayamakApi;

class MelipayamakRepository implements SMSRepositoryInterface
{
    public function send($body, $idPattern, $mobile)
    {
        $username = env('MELIPAYAMAK_USERNAME');
        $password = env('MELIPAYAMAK_PASSWORD');
        $api = new MelipayamakApi($username, $password);
        $sms = $api->sms("soap");
        $to = $mobile;
        $response = $sms->sendByBaseNumber($body, $to, $idPattern);
        $json = json_decode($response);
        Log::info($json);
        return ['status' => 200, 'message' => 'ارسال موفق بود '];
    }


    public function sendSMSSendCode($code, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_CODE');
        Log::info($idPattern);
        return $this->send([$code], $idPattern, $mobile);
    }

    public function sendSMSToUserAwaitingRestaurantApproval($orderId, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_USER_AWAITING_RESTAURANT_APPROVAL');
        return $this->send([$orderId], $idPattern, $mobile);
    }

    public function sendSMSOrderStatus($orderId, $textStatus, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_USER_ORDER_STATUS');
        return $this->send([$orderId, $textStatus], $idPattern, $mobile);
    }

    public function sendSMSOrderDeliveredWithCashBack($name, $amount, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_USER_ORDER_DELIVERED_CASHBACK');

        return $this->send([$name, (string)$amount], $idPattern, $mobile);
    }

    public function sendSMSToDriver($orderId, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_DRIVER_NEW_ORDER');
        return $this->send([$orderId], $idPattern, $mobile);
    }

    public function sendSMSNewOrder($orderId, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TO_RESTAURANT_NEW_ORDER');
        return $this->send([$orderId], $idPattern, $mobile);
    }

    public function sendSMSTicketAnswered($ticketId, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TICKETING_ANSWERED');
        return $this->send([$ticketId], $idPattern, $mobile);
    }

    public function sendSMSWaitingAnswer($ticketId, $mobiles)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_TICKETING_WAITING_ANSWER');
        return $this->send([$ticketId], $idPattern, $mobiles);
    }

    public function OpenOrderReminder($orderId, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_Open_Order_Reminder');
        return $this->send([$orderId], $idPattern, $mobile);
    }
    public function sendSMSCashBack($mobile, $restaurantName, $priceCashBack, $date)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_CASH_BACK');
        return $this->send(['restaurantName' => $restaurantName, 'priceCashBack' => $priceCashBack, 'date' => $date], $idPattern, $mobile);
    }

    public function sendSMSOrderDelayApproval($orderId, $customerName, $orderAmount, $restaurantName, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_ORDER_DELAY_APPROVAL');
        return $this->send([$orderId, $customerName, $orderAmount, $restaurantName], $idPattern, $mobile);
    }

    public function sendSMSOrderDelayDelivery($orderId, $customerName, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_ORDER_DELAY_DELIVERY');
        return $this->send([$orderId, $customerName], $idPattern, $mobile);
    }

    public function sendSMSInactiveProducts($inactiveCount, $restaurantName, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_INACTIVE_PRODUCTS');
        return $this->send([$inactiveCount, $restaurantName], $idPattern, $mobile);
    }

    public function sendSMSWelcomeCoupon($couponCode, $mobile)
    {
        $idPattern = env('MELIPAYAMAK_SEND_SMS_WELCOME_COUPON');
        return $this->send([$couponCode], $idPattern, $mobile);
    }
}
