<?php

namespace App\Repositories\SMS;

use App\Models\Gateway;

interface SMSRepositoryInterface
{
    public function send($body, $idPattern, $mobile);

    public function sendSMSSendCode($code, $mobile);

    public function sendSMSToUserAwaitingRestaurantApproval($orderId, $mobile);
    public function sendSMSOrderDeliveredWithCashBack($name, $amount, $mobile);

    public function sendSMSOrderStatus($orderId, $textStatus, $mobile);

    public function sendSMSToDriver($orderId, $mobile);

    public function sendSMSNewOrder($orderId, $mobile);

    public function OpenOrderReminder($orderId, $mobile);

    public function sendSMSCashBack($mobile, $restaurantName, $priceCashBack, $date);

    public function sendSMSOrderDelayApproval($orderId, $customerName, $orderAmount, $restaurantName, $mobile);

    public function sendSMSOrderDelayDelivery($orderId, $customerName, $mobile);

    public function sendSMSInactiveProducts($inactiveCount, $restaurantName, $mobile);

    public function sendSMSWelcomeCoupon($couponCode, $mobile);

}
