<?php

namespace App\Repositories\Setting;

use App\Models\Setting;
use App\Models\Variety;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

abstract class  EloquentRepository
{
    abstract public function model();

    public function getSettingShippingType()
    {
        Setting::where('name', 'shippingType')->where('branch_id', null)->latest()->first();
    }

    public function getSettingShippingTypeAndPrice()
    {
        $setting = Setting::whereIn('name', ['shippingCost', 'deliveryFreeKilometer', 'fixedShippingCost', 'fixedShippingKilometer'])->where('branch_id', null)->get()->pluck('value', 'name')->toArray();
        return $setting;
    }

    public function getTaxPercent()
    {
        $setting = Setting::where('name', 'taxPercent')->latest()->first();
        return $setting->value ?? 0;
    }

    public function maxDistance()
    {
        $setting = Setting::where('name', 'maxDistance')->latest()->first();
        return $setting->value ?? 30;
    }


    public function getSettingWithName($name)
    {
        return Setting::where('name', $name)->latest()->first();
    }

    public function getSettingWithNames($names)
    {
        return Setting::whereIn('name', $names)->get()->pluck('value', 'name')->toArray();
    }

    public function storeOrUpdate($data)
    {

    }


}
