<?php

namespace App\Repositories\Slider;

use App\Enums\SettlementRequestStatus;
use App\Enums\TransactionType;
use App\Models\Branch;
use App\Models\Slider;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\Transaction\TransactionRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Slider $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['branch_id']) && !empty($filter['branch_id'])) {
                    $q->where('branch_id', $filter['branch_id']);
                }

                if (isset($filter['type']) && !empty($filter['type'])) {
                    $q->where('type', $filter['type']);
                }
            })->orderBy('id', 'DESC');
            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            return null;
        }
    }

}
