<?php

namespace App\Repositories\SmsSetting;

use App\Models\SmsSetting;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository implements RepositoryInterface
{
    public function __construct(SmsSetting $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [])
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%')
                      ->orWhere('repository', 'like', '%' . $filter['search'] . '%');
                }

                if (isset($filter['status']) && $filter['status'] !== '') {
                    $q->where('status', $filter['status']);
                }

                if (isset($filter['repository']) && !empty($filter['repository'])) {
                    $q->where('repository', $filter['repository']);
                }
            })->with('branch')->orderBy('id', 'desc');

            if (isset($filter['paginate']) && $filter['paginate']) {
                return $data->paginate($filter['per_page'] ?? 15);
            }

            return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return collect();
        }
    }
}
