<?php

namespace App\Repositories\Ticket;


use App\Models\Ticket;
use App\Models\TicketCategory;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;


abstract class  EloquentRepository extends BaseRepository
{


    public function __construct(Ticket $model)
    {
        parent::__construct($model);
    }


    public function getTickets()
    {
        return $this->model->where('user_id', auth()->id())->where('parent_id', 0)->with('category')->paginate(10);
    }

    public function getCategory()
    {
        return TicketCategory::where('show_front',true)->get();
    }
    public function getCategoryAdmin()
    {
        return TicketCategory::all();
    }

    public function getTicketsByFilter($filter, $paginate = true)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['category_id']) && !empty($filter['category_id'])) {
                    $q->where('category_id', $filter['category_id']);
                }
                if (isset($filter['status']) && !empty($filter['status'])) {
                    $q->where('status', $filter['status']);
                }
                if (isset($filter['user_id']) && !empty($filter['user_id'])) {
                    $q->where('user_id', $filter['user_id']);
                }
                if (isset($filter['start_date']) && isset($filter['end_date']) && !empty($filter['start_date']) && !empty($filter['end_date'])) {
                    $startDate = \Morilog\Jalali\Jalalian::fromFormat('Y/m/d', $filter['start_date'])->toCarbon();
                    $endDate = \Morilog\Jalali\Jalalian::fromFormat('Y/m/d', $filter['end_date'])->toCarbon();
                    $q->where('created_at', '>=', $startDate)->where('created_at', '<=', $endDate);
                }
            })->where('parent_id', 0)->with('category:id,title');
            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function showTicket($id)
    {
        return $this->model->where('user_id', auth()->id())->where('parent_id', 0)->where('id', $id)->with('category', 'child', 'user:id,name,family')->first();
    }


    public function updateStatus($id, $status)
    {
        return $this->model->where('id', $id)->update(['status' => $status]);
    }

    public function showTicketAdmin($id)
    {
        return $this->model->where('parent_id', 0)->where('id', $id)->with('category', 'child', 'user:id,name,family')->first();
    }


}
