<?php

namespace App\Repositories\Transaction;

use App\Enums\TransactionType;
use App\Exports\TransactionsExport;
use App\Models\Material;
use App\Models\Transaction;
use App\Repositories\BaseRepository\BaseRepository;
use App\Repositories\ExportImport\ExportImportRepository;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Excel;

abstract class  EloquentRepository extends BaseRepository
{
    public function __construct(Transaction $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['user_id']) && !empty($filter['user_id'])) {
                    $q->where('user_id', $filter['user_id']);
                }
                if (isset($filter['transaction_type']) && !empty($filter['transaction_type'])) {
                    $q->where('transaction_type', $filter['transaction_type']);
                }
                if (isset($filter['start_date']) && isset($filter['end_date']) && !empty($filter['start_date']) && !empty($filter['end_date'])) {
                    $startDate = \Morilog\Jalali\Jalalian::fromFormat('Y/m/d', $filter['start_date'])->toCarbon();
                    $endDate = \Morilog\Jalali\Jalalian::fromFormat('Y/m/d', $filter['end_date'])->toCarbon();
                    $q->where('created_at', '>=', $startDate)->where('created_at', '<=', $endDate);
                }
            })->with('order', 'user')->orderBy('created_at', 'desc');


            $allProfitSales = clone $data;
            $allProfitDelivery = clone $data;
            $allPriceOrder = clone $data;
            $allPriceDelivery = clone $data;
            $allPriceBankDeposit = clone $data;
            $sumWallet = clone $data;
            $count = clone $data;

            if (isset($filter['export']) and $filter['export'] == true) {
                $export = clone $data;
                app(ExportImportRepository::class)->createExcelFileTransactions($export->get()->toArray());
            }

            if ($paginate)
                return ["data" => $data->paginate(25), 'count' => $count->count(), "allProfitSales" => $allProfitSales->where('transaction_type', TransactionType::SALESPROFIT)->sum('amount'),
                    "allProfitDelivery" => $allProfitDelivery->where('transaction_type', TransactionType::DELIVERPROFIT)->sum('amount'),
                    "allPriceOrder" => $allPriceOrder->where('transaction_type', TransactionType::SALES)->sum('amount'),
                    "allPriceDelivery" => $allPriceDelivery->where('transaction_type', TransactionType::DELIVER)->sum('amount'),
                    "allPriceBankDeposit" => $allPriceBankDeposit->where('transaction_type', TransactionType::BANKDEPOSIT)->sum('amount'),
                    "sumWallet" => $sumWallet->sum('amount'),
                ];
            return ["data" => $data->get(), 'count' => $count->count(), "allProfitSales" => $allProfitSales->where('transaction_type', TransactionType::SALESPROFIT)->sum('amount'),
                "allProfitDelivery" => $allProfitDelivery->where('transaction_type', TransactionType::DELIVERPROFIT)->sum('amount'),
                "allPriceOrder" => $allPriceOrder->where('transaction_type', TransactionType::SALES)->sum('amount'),
                "allPriceBankDeposit" => $allPriceBankDeposit->where('transaction_type', TransactionType::BANKDEPOSIT)->sum('amount'),
                "allPriceDelivery" => $allPriceOrder->where('transaction_type', TransactionType::DELIVER)->sum('amount')
            ];
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function userInventory()
    {
        return $this->model->where('user_id', auth()->id())->sum('amount');
    }

    public function userInventoryWithUser($userId)
    {
        return $this->model->where('user_id', $userId)->sum('amount');
    }


    public function storeP(array $data)
    {
        try {
            return $this->model->create($data);
        } catch (QueryException $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

}
