<?php

namespace App\Repositories\Unit;

use App\Models\Unit;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Unit $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [])
    {
        try {
            return $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
            })->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }
}
