<?php

namespace App\Repositories\UserOrder;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface UserOrderRepositoryInterface
{
    /**
     * Get user's order history from a specific branch.
     *
     * @param int $userId
     * @param int $branchId
     * @param array $filters
     * @param int $perPage
     * @return LengthAwarePaginator
     */
    public function getUserBranchOrders(int $userId, int $branchId, array $filters = [], int $perPage = 15): LengthAwarePaginator;

    /**
     * Get user's order statistics from a specific branch.
     *
     * @param int $userId
     * @param int $branchId
     * @param array $filters
     * @return array
     */
    public function getUserBranchOrderStats(int $userId, int $branchId, array $filters = []): array;

    /**
     * Get user's favorite products from a specific branch.
     *
     * @param int $userId
     * @param int $branchId
     * @param int $limit
     * @return array
     */
    public function getUserFavoriteProducts(int $userId, int $branchId, int $limit = 10): array;
}
