<?php

namespace App\Repositories\Variety;

use App\Models\Variety;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

abstract class  EloquentRepository
{
    abstract public function model();


    public function getById($id)
    {
        return Variety::find($id);
    }

    public function getByIdWithProduct($id)
    {
        return Variety::find($id)->with('Product:id,branch_id');
    }


    public function getBranch($variety)
    {
        return Variety::find($variety)->product->branch;
    }

    public function decrementCount($varietyId, $count)
    {
        return Variety::where('id', $varietyId)
            ->where('count', '>=', $count)
            ->decrement('count', $count);
    }

    public function incrementCount($varietyId, $count)
    {
        return Variety::where('id', $varietyId)
            ->increment('count', $count);
    }
}
