<?php

namespace App\Repositories\Vendor;

use App\Models\Product;
use App\Models\Variety;
use App\Models\Vendor;
use App\Models\VendorRegister;
use App\Repositories\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Log;

abstract class EloquentRepository extends BaseRepository
{
    public function __construct(Vendor $model)
    {
        parent::__construct($model);
    }

    public function getWithFilter(array $filter = [], $paginate = false)
    {
        try {
            $data = $this->model->where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('title', 'like', '%' . $filter['search'] . '%');
                }
            })->with('branch');


            if (!empty($filter['sort_column'])) {
                $sortType = (!empty($filter['sort_type'])) ? $filter['sort_type'] : "desc";
                $data = $data->orderBy($filter['sort_column'], $sortType);
            }



            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function getRegisters(array $filter = [], $paginate = false)
    {
        try {
            $data = VendorRegister::where(function ($q) use ($filter) {
                if (isset($filter['search']) && !empty($filter['search'])) {
                    $q->where('name', 'like', '%' . $filter['search'] . '%')->orWhere('family', 'like', '%' . $filter['search'] . '%');
                }
            });

            if (!empty($filter['sort_column'])) {
                $sortType = (!empty($filter['sort_type'])) ? $filter['sort_type'] : "desc";
                $data = $data->orderBy($filter['sort_column'], $sortType);
            }


            if ($paginate)
                return $data->paginate(25);
            return $data->get();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }

    public function storeP($data)
    {
        try {
            $n = new Vendor();
            $n->title = $data['title'];
            $n->user_id = $data['user_id'];
            $n->save();
            return $n;
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }


    public function showWithRel($id)
    {
        try {
            return Product::where('id',$id)->with('branch')->first();
        } catch (\Exception $e) {
            Log::error($e->getMessage());
            return null;
        }
    }



    public function varietyStoreOrUpdate($data)
    {
        try {
            if (isset($data['variety_id'])) {
                Variety::find($data['variety_id'])->update($data);
            } else {
                Variety::create($data);
            }
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    public function register($data)
    {
        return VendorRegister::create($data);
    }

}
