<?php

namespace App\Services;

use App\Repositories\AreaManagment\AreaManagmentRepository;
use App\Repositories\Address\AddressRepository;
use App\Repositories\Area\AreaRepository;
use App\Helpers\PointInPolygonHelper;

class AreaManagementService
{
    public function __construct(
        protected AreaManagmentRepository $areaManagmentRepository,
        protected AddressRepository $addressRepository,
        protected AreaRepository $areaRepository
    ) {}

    public function getActiveAreaForAddress($addressId, $branchId, $currentDay, $currentTime, $lat, $lng)
    {
        $areaManagements = $this->areaManagmentRepository->getActiveByBranchDayTime($branchId, $currentDay, $currentTime);
        $areaIds = $areaManagements->pluck('area_id')->unique()->toArray();
        $areas = $this->areaRepository->getByIds($areaIds);

        if ($addressId) {
            $address = $this->addressRepository->find($addressId);

            if (!$address || !isset($address->lat) || !isset($address->lng)) return null;

            foreach ($areas as $area) {
                if (PointInPolygonHelper::check([$address->lat, $address->lng], $area->coordinates)) {
                    return $areaManagements->where('area_id', $area->id)->first();
                }
            }
        }else{
            foreach ($areas as $area) {
                if (PointInPolygonHelper::check([$lat, $lng], $area->coordinates)) {
                    return $areaManagements->where('area_id', $area->id)->first();
                }
            }
        }
        return null;
    }
}
