<?php

namespace App\Swagger\v1;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class AreaEndpoints
{

    /**
     * @OA\Get(
     *     path="/areas",
     *     tags={"front-area-v1"},
     *     summary="Get list of areas",
     *     description="Retrieve a list of areas, filtered by area ID or parent ID if provided.",
     *     @OA\Parameter(
     *         name="parent_id",
     *         in="query",
     *         description="ID of the parent area to filter",
     *         required=false,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with list of areas",
     *         @OA\JsonContent(type="object")
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Validation error",
     *         @OA\JsonContent(type="object")
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error",
     *         @OA\JsonContent(type="object")
     *     )
     * )
     */
    public function getArea($request)
    {
    }


}
