<?php
namespace App\Swagger\v1;

/**
 * Class AuthEndpoints
 * @package App\Swagger\v1
 */
class AuthEndpoints {

    /**
     * @OA\Post(
     *     path="/auth/send_code",
     *     tags={"auth-v1"},
     *     summary="Send verification code",
     *     description="Send a verification code to the user's mobile number",
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             @OA\Property(
     *                 property="mobile",
     *                 type="string",
     *                 example="09013234324",
     *                 description="Mobile number to send the verification code to"
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="[message='success message',data=[],status=200]"
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Validation error [ message='first validate params message',data=[],status=400]"
     *     )
     * )
     */
    public function sendCode() {}

    /**
     * @OA\Post(
     *     path="/auth/check_code",
     *     tags={"auth-v1"},
     *     summary="Check code verification code",
     *     description="Verify the received code for the user's mobile number",
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             @OA\Property(
     *                 property="mobile",
     *                 type="string",
     *                 example="09013234324",
     *                 description="Mobile number to verify the code"
     *             ),
     *             @OA\Property(
     *                 property="code",
     *                 type="string",
     *                 example="1111",
     *                 description="Code received via SMS"
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="[message='success message',data=[],status=200]"
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Validation error [ message='first validate params message',data=[],status=400]"
     *     )
     * )
     */
    public function checkCode() {}
}
