<?php

namespace App\Swagger\v1;

/**
 * Class branchEndpoints
 * @package App\Swagger\v1
 */
class BranchEndpoints
{
    /**
     * @OA\Get(
     *     path="/branch",
     *     tags={"front-branches-v1"},
     *     summary="get all branch with filter",
     *     description="get all branches with filters",
     *      @OA\RequestBody(
     *          required=false,
     *          @OA\JsonContent(
     *              @OA\Property(
     *                  property="title",
     *                  type="string",
     *                  example="تست",
     *                  description="search with title branch"
     *              ),
     *              @OA\Property(
     *                  property="area_id",
     *                  type="number",
     *                  example="15",
     *                  description="get branches and filter area"
     *              ),
     *              @OA\Property(
     *                  property="category_id",
     *                  type="number",
     *                  example="10",
     *                  description="get branches and filter category"
     *              ),
     *              @OA\Property(
     *                  property="lat",
     *                  type="string",
     *                  example="31.000000",
     *                  description="get branches and filter area with lat and lng"
     *              ),
     *              @OA\Property(
     *                  property="lng",
     *                  type="string",
     *                  example="51.000000",
     *                  description="get branches and filter area with lat and lng"
     *              )
     *          )
     *      ),
     *     @OA\Response(
     *         response=200,
     *         description="[status=> 200, message => '', data => [products => []]"
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="['error' => $validator->errors()->first()]"
     *     )
     * )
     */
    public function getAllBranches()
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/show/{id}",
     *     tags={"front-branches-v1"},
     *     summary="get one branch",
     *     description="get one branch",
     *          @OA\Parameter(
     *          name="id",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function show($id)
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/get-gallery/{branchId}",
     *     tags={"front-branches-v1"},
     *     summary="get gallery branch",
     *     description="get gallery branch",
     *          @OA\Parameter(
     *          name="branchId",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function getGalleryBranch($branchId)
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/delivery-types/{branchId}",
     *     tags={"front-branches-v1"},
     *     summary="get delivery types branch",
     *     description="get delivery types branch",
     *          @OA\Parameter(
     *          name="branchId",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function deliveryTypes($branchId)
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/getActivityTime/{branchId}",
     *     tags={"front-branches-v1"},
     *     summary="get acrivity time branch",
     *     description="get acrivity time branch Based on week day",
     *          @OA\Parameter(
     *          name="branchId",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function getActivityTime($branchId)
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/get-status-now/{branchId}",
     *     tags={"front-branches-v1"},
     *     summary="get-status-now",
     *     description="current situation branch",
     *          @OA\Parameter(
     *          name="branchId",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function getNowStatus($branchId)
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/per-order-time/{branchId}",
     *     tags={"front-branches-v1"},
     *     summary="get-per-order-time branch",
     *     description="check and get per ordertime branch",
     *          @OA\Parameter(
     *          name="branchId",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function perOrderTime($branchId)
    {
    }


    /**
     * @OA\Get(
     *     path="/branch/get-times-active-day/{branchId}",
     *     tags={"front-branches-v1"},
     *     summary="get-days for per day",
     *     description="Get all active days in a restaurant",
     *          @OA\Parameter(
     *          name="branchId",
     *          in="path",
     *          required=true,
     *          description="ID of the branch to retrieve",
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful response",
     *      ),
     *      @OA\Response(
     *          response=404,
     *          description="Branch not found"
     *      )
     * )
     */
    public function getActivityDay($branchId)
    {
    }



    /**
     * @OA\Get(
     *     path="/comment/branch/{branchId}",
     *     summary="Retrieve comments for a specific branch",
     *     description="Fetches all comments associated with a given branch ID.",
     *     operationId="getCommentBranch",
     *     tags={"front-branches-v1"},
     *     @OA\Parameter(
     *         name="branchId",
     *         in="path",
     *         description="ID of the branch to retrieve comments for",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="A list of comments for the branch",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="user", type="string", example="John Doe"),
     *                     @OA\Property(property="comment", type="string", example="Excellent service!"),
     *                     @OA\Property(property="rating", type="integer", example=5),
     *                     @OA\Property(property="created_at", type="string", format="date-time", example="2024-11-01T12:34:56Z")
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=404,
     *         description="Branch not found",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="Branch not found.")
     *         )
     *     )
     * )
     */
    public function getCommentBranch($branchId)
    {
    }


    /**
     * @OA\Get(
     *     path="/comment/branch/rate/{branchId}",
     *     summary="Retrieve comments for a specific branch",
     *     description="Fetches all comments associated with a given branch ID.",
     *     operationId="getRateBranch",
     *     tags={"front-branches-v1"},
     *     @OA\Parameter(
     *         name="branchId",
     *         in="path",
     *         description="ID of the branch to retrieve comments for",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="A list of comments for the branch",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="user", type="string", example="John Doe"),
     *                     @OA\Property(property="comment", type="string", example="Excellent service!"),
     *                     @OA\Property(property="rating", type="integer", example=5),
     *                     @OA\Property(property="created_at", type="string", format="date-time", example="2024-11-01T12:34:56Z")
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=404,
     *         description="Branch not found",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="Branch not found.")
     *         )
     *     )
     * )
     */
    public function getRateBranch($branchId)
    {
    }


}
