<?php

namespace App\Swagger\v1;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class CategoryEndpoints
{
    /**
     * @OA\Get(
     *     path="/category",
     *     summary="Retrieve filtered categories",
     *     description="Fetches categories based on optional filters like area_id, branch_id, and time.",
     *     operationId="getCategories",
     *     tags={"front-Category-v1"},
     *     @OA\Parameter(
     *         name="area_id",
     *         in="query",
     *         description="ID of the area to filter categories by",
     *         required=false,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="branch_id",
     *         in="query",
     *         description="ID of the branch to filter categories by",
     *         required=false,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="time",
     *         in="query",
     *         description="Time to filter categories by, in H:i:s format",
     *         required=false,
     *         @OA\Schema(
     *             type="string",
     *             format="time",
     *             example="14:30:00"
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="parent_id",
     *         in="query",
     *         description="ID of the parent category",
     *         required=false,
     *         @OA\Schema(
     *             type="integer",
     *             example=0
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with category data",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="title", type="string", example="Sample Category"),
     *                     @OA\Property(property="img", type="string", example="category.png"),
     *                     @OA\Property(property="parent_id", type="integer", example=0),
     *                     @OA\Property(property="branch_id", type="integer", example=1),
     *                     @OA\Property(property="start_serving", type="string", format="time", example="09:00:00"),
     *                     @OA\Property(property="end_serving", type="string", format="time", example="21:00:00")
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Bad request, validation error",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="The branch_id field is required.")
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Internal Server Error"
     *     )
     * )
     */
    public function getCategories($request)
    {
    }


}
