<?php

namespace App\Swagger\v1;

/**
 * Class ComponentEndpoints
 * @package App\Swagger\v1
 */
class ComponentEndpoints
{

    /**
     * @OA\Get(
     *     path="/component/get-list-components/{type}/{slug?}",
     *     tags={"front-components-v1"},
     *     summary="List components",
     *     description="Retrieve a list of components based on type and optional slug",
     *     @OA\Parameter(
     *            name="type",
     *            in="path",
     *            example="main",
     *            required=true,
     *            description="Type of the page",
     *            @OA\Schema(type="string")
     *        ),
     *     @OA\Parameter(
     *            name="slug",
     *            in="path",
     *            example="home",
     *            required=false,
     *            description="Slug of the page (optional)",
     *            @OA\Schema(type="string")
     *        ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with list of components",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="data", type="array", @OA\Items(type="object"))
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error"
     *     )
     * )
     */
    public function getComponents($type, $slug)
    {}


    /**
     * @OA\Get(
     *     path="/component/get-with-code/{code}",
     *     tags={"front-components-v1"},
     *     summary="List components",
     *     description="Retrieve a list of components based on type and optional slug",
     *     @OA\Parameter(
     *            name="code",
     *            in="path",
     *            example="csdcsmdkcm254542358",
     *            required=true,
     *            description="from table components : field = code ",
     *            @OA\Schema(type="string")
     *        ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with list of components",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="data", type="array", @OA\Items(type="object"))
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error"
     *     )
     * )
     */
    public function getWithCode($code)
    {}
}
