<?php

namespace App\Swagger\v1;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class ProductEndpoints
{
    /**
     * @OA\Get(
     *     path="/product/",
     *     tags={"front-product-v1"},
     *     summary="Get list of products",
     *     description="Retrieve a paginated list of products with various filters",
     *     @OA\Parameter(
     *         name="order_by",
     *         in="query",
     *         description="Order by rate (desc) or id",
     *         required=false,
     *         @OA\Schema(type="string", enum={"rate", "desc"})
     *     ),
     *     @OA\Parameter(
     *         name="branch_id",
     *         in="query",
     *         description="ID of the branch to filter",
     *         required=false,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Parameter(
     *         name="category_id",
     *         in="query",
     *         description="ID of the category to filter",
     *         required=false,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Parameter(
     *         name="title",
     *         in="query",
     *         description="Search term for the product title",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Parameter(
     *         name="price_start",
     *         in="query",
     *         description="Minimum price",
     *         required=false,
     *         @OA\Schema(type="number", format="float")
     *     ),
     *     @OA\Parameter(
     *         name="price_end",
     *         in="query",
     *         description="Maximum price",
     *         required=false,
     *         @OA\Schema(type="number", format="float")
     *     ),
     *     @OA\Parameter(
     *         name="material_ids",
     *         in="query",
     *         description="IDs of materials, separated by dashes (e.g., 1-2-3)",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Parameter(
     *         name="has_discount",
     *         in="query",
     *         description="Filter products with a discount",
     *         required=false,
     *         @OA\Schema(type="boolean")
     *     ),
     *     @OA\Parameter(
     *         name="lat",
     *         in="query",
     *         description="Latitude for filtering products by branch location",
     *         required=false,
     *         @OA\Schema(type="number", format="float")
     *     ),
     *     @OA\Parameter(
     *         name="lng",
     *         in="query",
     *         description="Longitude for filtering products by branch location",
     *         required=false,
     *         @OA\Schema(type="number", format="float")
     *     ),
     *     @OA\Parameter(
     *         name="paginate",
     *         in="query",
     *         description="Number of products per page",
     *         required=false,
     *         @OA\Schema(type="integer", default=10)
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with list of products",
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error"
     *     )
     * )
     */
    public function listProducts()
    {
    }

    /**
     * @OA\Get(
     *     path="/product/get_category_all_with_branch",
     *     tags={"front-product-v1"},
     *     summary="front-product-category-v1",
     *     description="Retrieve a list of categories with optional filters",
     *     @OA\Parameter(
     *         name="branch_id",
     *         in="query",
     *         description="ID of the branch to filter categories",
     *         required=false,
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Parameter(
     *         name="title",
     *         in="query",
     *         description="Filter categories by the product title",
     *         required=false,
     *         @OA\Schema(type="string")
     *     ),
     *     @OA\Parameter(
     *         name="time",
     *         in="query",
     *         description="Filter categories by serving time (e.g., 14:00:00)",
     *         required=false,
     *         @OA\Schema(type="string", format="time", example="14:30:00")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with category data",
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Validation error",
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error",
     *     )
     * )
     */
    public function getCategoryAll($request)
    {
    }



    /**
     * @OA\Get(
     *     path="/product/{id}",
     *     tags={"front-product-v1"},
     *     summary="Get a product by ID with all related information",
     *     description="Retrieve detailed information of a product, including all related data by specifying the product ID.",
     *     @OA\Parameter(
     *         name="id",
     *         in="path",
     *         required=true,
     *         description="ID of the product to retrieve",
     *         @OA\Schema(type="integer")
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response with product data",

     *     ),
     *     @OA\Response(
     *         response=404,
     *         description="Product not found",

     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error",
     *     )
     * )
     */
    public function show($id)
    {
    }


    /**
     * @OA\Get(
     *     path="/comment/product/{productId}",
     *     summary="Retrieve comments for a specific product",
     *     description="Fetches all comments associated with a given product ID.",
     *     operationId="getCommentProduct",
     *     tags={"front-product-v1"},
     *     @OA\Parameter(
     *         name="productId",
     *         in="path",
     *         description="ID of the product to retrieve comments for",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="A list of comments for the product",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="user", type="string", example="John Doe"),
     *                     @OA\Property(property="comment", type="string", example="Great product!"),
     *                     @OA\Property(property="rating", type="integer", example=5),
     *                     @OA\Property(property="created_at", type="string", format="date-time", example="2024-11-01T12:34:56Z")
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=404,
     *         description="Product not found",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="Product not found.")
     *         )
     *     )
     * )
     */
    public function getCommentProduct($productId)
    {
    }





}
