<?php

namespace App\Swagger\v1;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class SearchEndpoints
{

    /**
     * @OA\Get(
     *     path="/search/",
     *     summary="Search for branches and products",
     *     description="This endpoint searches for branches and products based on a search term.",
     *     operationId="searchProductAndBranch",
     *     tags={"front-v1 Product & Branch"},
     *     @OA\Parameter(
     *         name="search",
     *         in="query",
     *         description="Search term for branches and products",
     *         required=false,
     *         @OA\Schema(
     *             type="string"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="object",
     *                 @OA\Property(
     *                     property="branches",
     *                     type="array",
     *                     @OA\Items(
     *                         type="object",
     *                         @OA\Property(property="id", type="integer", example=1),
     *                         @OA\Property(property="title", type="string", example="Branch Title"),
     *                         @OA\Property(property="logo", type="string", example="logo.png")
     *                     )
     *                 ),
     *                 @OA\Property(
     *                     property="product",
     *                     type="array",
     *                     @OA\Items(
     *                         type="object",
     *                         @OA\Property(property="id", type="integer", example=1),
     *                         @OA\Property(property="title", type="string", example="Product Title"),
     *                         @OA\Property(property="image", type="string", example="image.png")
     *                     )
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=404,
     *         description="Not Found"
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Internal Server Error"
     *     )
     * )
     */
    public function searchProductAndBranch($request)
    {
    }
}
