<?php

namespace App\Swagger\v1;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class SliderEndpoints
{
    /**
     * @OA\Get(
     *     path="/slider",
     *     summary="Retrieve a list of sliders",
     *     description="Fetches a list of sliders with optional filters for branch ID and slider type.",
     *     operationId="getSliders",
     *     tags={"front-Slider-v1"},
     *     @OA\Parameter(
     *         name="branche_id",
     *         in="query",
     *         description="ID of the branch to filter sliders by",
     *         required=false,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *     @OA\Parameter(
     *         name="type",
     *         in="query",
     *         description="Type of the slider (must be a valid enum value)",
     *         required=false,
     *         @OA\Schema(
     *             type="string",
     *             enum={"home", "chef_search", "product_search"},
     *             example="type1"
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Successful response",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="type", type="string", example="type1"),
     *                     @OA\Property(property="branche_id", type="integer", example=1),
     *                     @OA\Property(
     *                         property="product",
     *                         type="object",
     *                         @OA\Property(property="id", type="integer", example=1),
     *                         @OA\Property(property="title", type="string", example="Sample Product"),
     *                         @OA\Property(property="image", type="string", example="image.png")
     *                     )
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Bad request, validation error",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="The type field is required.")
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Internal Server Error"
     *     )
     * )
     */
    public function index( $request)
    {
    }

}
