<?php

namespace App\Swagger\v1;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class TicketEndpoints
{
    /**
     * @OA\Get(
     *     path="/ticket",
     *     summary="Retrieve all tickets",
     *     description="Fetches a list of all available tickets.",
     *     operationId="getTickets",
     *     tags={"front-Tickets-v1"},
     *     security={{"Bearer": {}}},
     *     @OA\Response(
     *         response=200,
     *         description="A list of tickets",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(
     *                 property="data",
     *                 type="array",
     *                 @OA\Items(
     *                     type="object",
     *                     @OA\Property(property="id", type="integer", example=1),
     *                     @OA\Property(property="title", type="string", example="Concert Ticket"),
     *                     @OA\Property(property="description", type="string", example="Ticket for the concert on 12th December."),
     *                     @OA\Property(property="price", type="number", format="float", example=25.99),
     *                     @OA\Property(property="created_at", type="string", format="date-time", example="2024-11-01T12:34:56Z")
     *                 )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Internal server error",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="Failed to retrieve tickets.")
     *         )
     *     )
     * )
     */
    public function index()
    {
    }

    /**
     * @OA\Post(
     *     path="/ticket/create",
     *     summary="Create a new ticket",
     *     security={{"Bearer": {}}},
     *     tags={"front-Tickets-v1"},
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"text", "subject", "category_id"},
     *             @OA\Property(property="text", type="string", description="Ticket text"),
     *             @OA\Property(property="subject", type="string", description="Ticket subject"),
     *             @OA\Property(property="category_id", type="integer", description="Category ID for the ticket"),
     *             @OA\Property(property="file", type="string", format="url", description="Optional file URL"),
     *             @OA\Property(property="parent_id", type="integer", description="Optional parent ticket ID")
     *         )
     *     ),
     *     @OA\Response(
     *         response=201,
     *         description="Ticket created successfully",

     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Validation error or failure",
     *         @OA\JsonContent(
     *             @OA\Property(property="error", type="string", description="Error message")
     *         )
     *     )
     * )
     */
    public function ticketCreate($request)
    {
    }



}
