<?php

namespace App\Swagger\v1;

use Illuminate\Http\Request;

/**
 * Class ProductEndpoints
 * @package App\Swagger\v1
 */
class VendorEndpoints
{
    /**
     * @OA\Post(
     *     path="/vendors/register",
     *     summary="Register a new user",
     *     description="Registers a user with provided details and optional socials.",
     *     operationId="registerUser",
     *     tags={"front-vendor-register-v1"},
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="name", type="string", example="John"),
     *             @OA\Property(property="family", type="string", example="Doe"),
     *             @OA\Property(property="tel", type="string", example="123456789"),
     *             @OA\Property(property="mobile", type="string", example="987654321"),
     *             @OA\Property(property="national_code", type="string", example="A12345678"),
     *             @OA\Property(property="user_name", type="string", example="johndoe"),
     *             @OA\Property(property="birthday", type="string", format="date", example="1990-01-01"),
     *             @OA\Property(property="referral_code", type="string", example="ABC123"),
     *             @OA\Property(property="address", type="string", example="123 Main St"),
     *             @OA\Property(
     *                 property="socials",
     *                 type="array",
     *                 @OA\Items(type="string"),
     *                 example={"facebook", "twitter"}
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="User registered successfully",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="data", type="object", example={"id": 1, "name": "John", "family": "Doe"})
     *         )
     *     ),
     *     @OA\Response(
     *         response=400,
     *         description="Validation error",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="error", type="string", example="The name field is required.")
     *         )
     *     ),
     *     @OA\Response(
     *         response=500,
     *         description="Server error",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="data", type="null")
     *         )
     *     )
     * )
     */
    public function register(Request $request)
    {
    }

}
