<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateComponentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('components', function (Blueprint $table) {
            $table->id();
            $table->string('name_component');
            $table->string('slug')->unique();
            $table->string('code')->unique();
            $table->json('filter')->nullable();
            $table->json('extra')->nullable();
            $table->integer('order');
            $table->enum('is_request', ['true', 'false']);
            $table->enum('type', ['header', 'main', 'footer']); // New 'type' field
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('components');
    }
}
