<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agents', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50);
            $table->string('family', 50);
            $table->string('mobile', 11);
            $table->string('national_code', 11);
            $table->string('address', 255);
            $table->string('code')->unique();
            $table->boolean('status')->default(true);
            $table->foreignIdFor(\App\Models\Area::class);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agents');
    }
};
