<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('user_id')->index('user');
            $table->string('title', 255);
            $table->string('lat', 255)->nullable();
            $table->string('lng', 255)->nullable();
            $table->text('address');
            $table->string('detail', 255)->default('0');
            $table->string('phone_number', 255)->nullable();
            $table->string('plaque', 255)->nullable();
            $table->string('unit', 255)->nullable();
            $table->string('postal_code', 255)->nullable();
            $table->dateTime('created_at');
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->integer('area_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('addresses');
    }
};
