<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branch_delivery_types', function (Blueprint $table) {
            $table->integer('branch_id');
            $table->integer('delivery_type_id');
            $table->timestamp('created_at')->useCurrentOnUpdate()->nullable();

            $table->primary(['branch_id', 'delivery_type_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branch_delivery_types');
    }
};
