<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('title', 255);
            $table->string('address', 255);
            $table->string('lat', 255);
            $table->string('lng', 255);
            $table->enum('main_branch', ['true', 'false'])->default('true');
            $table->integer('category_id');
            $table->integer('area_id')->index('area');
            $table->integer('vendor_id')->index('vendor');
            $table->string('min_order', 255)->default('120000');
            $table->text('sm_description')->nullable();
            $table->string('logo', 255)->nullable();
            $table->string('cover', 255)->nullable();
            $table->text('description')->nullable();
            $table->string('slug', 255)->default('0');
            $table->string('rate', 255)->default('0');
            $table->json('activities')->nullable();
            $table->json('meals')->nullable()->comment('Breakfast,Lunch,Dinner');
            $table->enum('status', ['active', 'disable', 'temporarily_disabled'])->default('active');
            $table->enum('cash_back_status', ['true', 'false'])->nullable()->default('false');
            $table->integer('cash_back_percent')->nullable()->default(0);
            $table->integer('cash_back_max_price')->nullable()->default(0);
            $table->enum('per_order_status', ['true', 'false'])->nullable()->default('true');
            $table->integer('per_order_day')->nullable()->default(1);
            $table->integer('agent_id')->nullable();
            $table->dateTime('created_at');
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};
