<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('charge_wallets', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('user_id');
            $table->string('amount', 255);
            $table->string('code_pay', 255);
            $table->string('payment_code_gateway', 255)->nullable();
            $table->enum('status', ['true', 'false'])->nullable()->default('false');
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('charge_wallets');
    }
};
