<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comments', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('text', 255);
            $table->integer('user_id');
            $table->float('rate', null, 0)->default(0);
            $table->json('products')->nullable()->comment('{{\'id\':\'1\',\'title\':\'مرغ سوخاری\'}}');
            $table->integer('branch_id')->nullable()->default(0);
            $table->integer('order_id')->default(0);
            $table->integer('parent_id')->default(0);
            $table->dateTime('created_at')->useCurrentOnUpdate()->nullable();
            $table->dateTime('updated_at')->useCurrentOnUpdate()->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comments');
    }
};
