<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('components', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name_component');
            $table->enum('slug', ['home'])->default('home');
            $table->string('code')->unique();
            $table->json('filter')->nullable();
            $table->json('extra')->nullable();
            $table->integer('order');
            $table->enum('is_request', ['true', 'false']);
            $table->enum('type', ['header', 'main', 'footer'])->default('main');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('components');
    }
};
