<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupon_branches', function (Blueprint $table) {
            $table->integer('coupon_id');
            $table->integer('branch_id');
            $table->timestamp('crated_at')->useCurrent();

            $table->primary(['coupon_id', 'branch_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupon_branches');
    }
};
