<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupon_users', function (Blueprint $table) {
            $table->integer('coupon_id');
            $table->integer('user_id');
            $table->enum('used', ['true', 'false'])->default('false');
            $table->integer('order_id')->default(0);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('used_at')->nullable();

            $table->primary(['coupon_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupon_users');
    }
};
