<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('title');
            $table->string('code', 10);
            $table->unsignedInteger('branch_id')->default(0);
            $table->integer('type')->default(1)->comment('0 - Fixed, 1 - Percentage');
            $table->integer('percent');
            $table->string('price', 255);
            $table->dateTime('active_from');
            $table->dateTime('active_to');
            $table->integer('limit_uses')->comment('محدودیت استفاده ');
            $table->enum('limit_user', ['true', 'false'])->default('false');
            $table->enum('limit_branch', ['true', 'false'])->default('false');
            $table->integer('used_count');
            $table->string('max_price_discount', 100)->nullable()->comment('سقف تخفیف');
            $table->string('min_price_order', 100)->nullable()->comment('حداقل خرید برای اعمال تخفیف');
            $table->enum('condition_type', ['count-order', 'after-rate', 'after-order', 'public'])->default('public');
            $table->integer('percent_system')->default(0);
            $table->integer('percent_branch')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
