<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_types', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('title', 255)->nullable();
            $table->boolean('is_cost')->default(false);
            $table->boolean('is_address')->nullable()->default(true);
            $table->string('description_text', 255)->nullable();
            $table->boolean('description_required')->default(false);
            $table->string('description_error_text', 255)->nullable();
            $table->boolean('is_active')->nullable()->default(true);
            $table->string('message', 255)->nullable();
            $table->timestamp('created_at')->useCurrentOnUpdate()->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delivery_types');
    }
};
