<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('extras', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('title', 255);
            $table->string('price', 255);
            $table->integer('branch_id')->index('branch');
            $table->integer('extra_type_id')->nullable()->index('type');
            $table->string('description', 255);
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('extras');
    }
};
