<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('materials', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title', 255);
            $table->integer('unit_id');
            $table->string('price_per_unit', 255)->default('0');
            $table->float('calorie_per_unit', null, 0)->default(0);
            $table->string('carbohydrate_per_unit', 255)->default('0');
            $table->string('fat_per_unit', 255)->default('0');
            $table->string('protein_per_unit', 255)->default('0');
            $table->string('image', 255);
            $table->integer('category_id')->default(0);
            $table->dateTime('created_at');
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('materials');
    }
};
