<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_carts', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('order_id');
            $table->integer('variety_id');
            $table->integer('count')->default(1);
            $table->string('price', 255);
            $table->string('discount', 255);
            $table->json('varietie')->nullable();
            $table->string('extra_ids', 255)->nullable();
            $table->json('extras')->nullable()->comment('[{\'id\':\'1\',\'title\':\'سس\',\'price\':\'15000\'}]');
            $table->dateTime('created_at')->useCurrentOnUpdate()->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_carts');
    }
};
