<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('address_id')->nullable()->index('address');
            $table->json('address')->nullable();
            $table->integer('branch_id')->nullable();
            $table->integer('driver_id')->nullable();
            $table->integer('user_id')->nullable()->index('user');
            $table->string('gust_token', 255)->nullable();
            $table->string('code', 255)->nullable();
            $table->enum('payment_type', ['online', 'wallet', 'hybrid'])->nullable();
            $table->enum('payment_status', ['true', 'false'])->nullable()->default('false');
            $table->string('payment_code', 255)->nullable();
            $table->string('payment_code_gateway', 255)->nullable();
            $table->string('order_price', 255)->nullable();
            $table->integer('wallet_use_price')->default(0);
            $table->integer('delivery_type_id')->nullable();
            $table->string('delivery_price', 255)->nullable();
            $table->string('cash_back_price', 255)->nullable()->default('0');
            $table->string('tax_price', 255)->nullable();
            $table->string('discount_price', 255)->nullable();
            $table->integer('coupon_id')->nullable();
            $table->integer('payment_getway_id')->nullable();
            $table->string('delivery_time', 255)->nullable();
            $table->string('preparation_time', 30)->nullable();
            $table->enum('order_status', ['ordering', 'wating_payment', 'awaiting_restaurant_approval', 'preparing', 'sending', 'delivered', 'ready_to_send', 'returned'])->nullable()->default('ordering');
            $table->text('carts')->nullable();
            $table->text('description')->nullable();
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
