<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title');
            $table->integer('user_id');
            $table->string('cover', 255);
            $table->text('content');
            $table->string('author')->nullable();
            $table->date('publication_date')->nullable();
            $table->enum('status', ['draft', 'published', 'archived'])->default('published');
            $table->unsignedBigInteger('post_category_id')->index('posts_post_category_id_foreign');
            $table->timestamps();
            $table->softDeletes();
            $table->string('keywords', 255)->nullable();
            $table->string('sm_description', 255)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};
