<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_defaults', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('category_id')->nullable()->default(0);
            $table->string('image', 255)->nullable();
            $table->json('images')->nullable();
            $table->string('title', 100);
            $table->string('min_description', 255)->nullable();
            $table->text('description')->nullable();
            $table->enum('status', ['awaiting_approval', 'disable', 'active'])->default('active');
            $table->dateTime('created_at');
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_defaults');
    }
};
