<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('branch_id');
            $table->integer('langueg_id')->default(0);
            $table->integer('product_defualt_id')->default(0);
            $table->integer('category_id')->nullable()->default(0);
            $table->integer('menu_id')->default(0)->comment('rel to category_id');
            $table->string('image', 255)->nullable();
            $table->json('images')->nullable();
            $table->string('title', 100);
            $table->string('min_description', 255)->nullable();
            $table->text('description')->nullable();
            $table->string('rate', 255)->nullable();
            $table->string('calory', 255)->nullable();
            $table->enum('status', ['awaiting_approval', 'disable', 'active'])->default('active');
            $table->dateTime('created_at');
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
