<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('title', 255);
            $table->string('link', 255)->nullable();
            $table->string('image', 255);
            $table->integer('product_id')->nullable()->default(0);
            $table->integer('branche_id')->default(0);
            $table->enum('type', ['home', 'chef_search', 'product_search'])->default('home');
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->useCurrentOnUpdate()->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sliders');
    }
};
