<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statusable', function (Blueprint $table) {
            $table->integer('id')->primary();
            $table->string('statusable_type', 255);
            $table->integer('statusable_id');
            $table->string('status_id', 255)->index('status');
            $table->integer('user_id')->index('user_copy_3');
            $table->dateTime('created_at');
            $table->dateTime('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statusable');
    }
};
