<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('subject', 255)->nullable();
            $table->string('text', 255);
            $table->enum('status', ['opened', 'closed', 'waiting_answer', 'answered'])->default('waiting_answer');
            $table->integer('category_id')->nullable();
            $table->integer('user_id');
            $table->integer('parent_id')->default(0);
            $table->string('file', 255)->nullable();
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tickets');
    }
};
