<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('user_id')->nullable();
            $table->string('amount', 255)->nullable();
            $table->enum('transaction_type', ['charge', 'pay_order', 'sales', 'sales_profit', 'deliver_profit', 'deliver', 'bank_deposit', 'returned', 'returned_system'])->nullable();
            $table->integer('target_id')->nullable()->default(0);
            $table->string('description', 255)->nullable();
            $table->dateTime('created_at')->useCurrentOnUpdate()->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
