<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('name', 255)->nullable();
            $table->string('family', 255)->nullable();
            $table->string('mobile', 255);
            $table->string('email', 255)->nullable();
            $table->string('birth_date', 255)->nullable();
            $table->string('username', 255)->nullable();
            $table->string('tel', 255)->nullable();
            $table->integer('role_id')->default(4);
            $table->integer('target_role_id')->default(0);
            $table->string('password', 255)->nullable();
            $table->integer('default_address_id')->default(0);
            $table->string('referral_code', 100)->nullable();
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
