<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('varieties', function (Blueprint $table) {
            $table->integer('id', true);
            $table->integer('product_id')->index('product');
            $table->string('title', 255);
            $table->string('min_description', 255)->nullable();
            $table->text('description')->nullable();
            $table->string('price', 255);
            $table->string('price_paking', 255)->default('0');
            $table->integer('count')->default(0);
            $table->string('discount', 255)->default('0')->comment('price discount');
            $table->string('order', 255)->default('0')->comment('ترتیب بندی');
            $table->integer('max_order')->default(20);
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('varieties');
    }
};
