<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vendor_registers', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('name', 255);
            $table->string('family', 255);
            $table->string('national_code', 255);
            $table->string('tel', 255)->nullable();
            $table->string('birthday', 255);
            $table->string('user_name', 255)->nullable();
            $table->string('referral_code', 255)->nullable();
            $table->text('address')->nullable();
            $table->string('mobile', 255)->default('0');
            $table->json('socials')->nullable();
            $table->dateTime('created_at')->useCurrentOnUpdate();
            $table->dateTime('updated_at')->nullable();
            $table->dateTime('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendor_registers');
    }
};
